package editor;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ExportImportDialog extends JDialog {
	
	public static final int CANCEL = -1;
	public static final int EXPORT_IMAGE = 0;
	public static final int EXPORT_PALETTE = 1;
	public static final int IMPORT_PALETTE = 2;
	
	
	private int selection;
	
	
	public ExportImportDialog(JFrame parent) {
		super(parent);
		
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new GridLayout(6, 1));
		
		mainPanel.add(new JPanel());
		
		JPanel exportImagePanel = new JPanel(new FlowLayout());
		JButton exportImageButton = new JButton("Export Current View...");
		exportImageButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				selection = EXPORT_IMAGE;
				dispose();
			}
		});
		exportImagePanel.add(exportImageButton);
		mainPanel.add(exportImagePanel);
		
		JPanel exportPalettePanel = new JPanel(new FlowLayout());
		JButton exportPaletteButton = new JButton("Export Palette...");
		exportPaletteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				selection = EXPORT_PALETTE;
				dispose();
			}
		});
		exportPalettePanel.add(exportPaletteButton);
		mainPanel.add(exportPalettePanel);
		
		
		JPanel importPalettePanel = new JPanel(new FlowLayout());
		JButton importPaletteButton = new JButton("Import Palette...");
		importPaletteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				selection = IMPORT_PALETTE;
				dispose();
			}
		});
		importPalettePanel.add(importPaletteButton);
		mainPanel.add(importPalettePanel);
		

		mainPanel.add(new JPanel());
		
		JPanel cancelPanel = new JPanel(new FlowLayout());
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				selection = CANCEL;
				dispose();
			}
		});
		cancelPanel.add(cancelButton);
		mainPanel.add(cancelPanel);
		
		this.setContentPane(mainPanel);
		
	}
	
	
	public int getSelection() {
		return selection;
	}
	
	
}
